﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Promotion
{
    public partial class Promotions : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindPromotionList(string.Empty, DateTime.Now, DateTime.Now);
            }
        }

        private void BindPromotionList(string searchWord, DateTime fromdate, DateTime todate)
        {
            List<Entities.Promotion> pbList = PromotionBL.GetList(Guid.Empty, fromdate, todate, searchWord);
            pbList = (from pb in pbList
                      where pb.IsActive
                      orderby pb.PromotionName ascending
                      select pb).ToList<Entities.Promotion>();
            grdPromoCode.DataSource = pbList;
            grdPromoCode.DataBind();

            if (pbList.Count == 0)
                WebUtilities.ShowMessage(this, "No Promotion found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindPromotionList(string.Empty,DateTime.MinValue,DateTime.MinValue);
            Master.ExportToExcel<Entities.Promotion>(grdPromoCode, "Promotions");
        }

        protected void grdPromoCode_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdPromoCode.PageIndex = e.NewPageIndex;
            BindPromotionList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                         (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindPromotionList(txtSearch.Text.Trim(), (string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                         (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindPromotionList(string.Empty, DateTime.MinValue, DateTime.MinValue);
        }
    }
}